package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysCountry;
import com.patzn.lims.sys.service.ISysCountryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 国家 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "国家表")
@RestController
@RequestMapping("/v1/country")
public class SysCountryController extends ServiceController<ISysCountryService, SysCountry> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysCountry>> getPage(SysCountry sysCountry) {
        this.haveSystemPermissions();
        return success(baseService.page(getPage(), sysCountry));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysCountry sysCountry) {
        this.haveSystemPermissions();
        return success(baseService.updateById(sysCountry));
    }

    @Override
    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(SysCountry sysCountry) {
        this.haveSystemPermissions();
        return success(baseService.save(sysCountry));
    }
}
