package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysFile;
import com.patzn.lims.sys.entity.SysFileHis;
import com.patzn.lims.sys.service.ISysFileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 文件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Api(tags = "文件表")
@RestController
@RequestMapping("/v1/sys_file")
public class SysFileController extends ServiceController<ISysFileService, SysFile> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysFile>> getPage(SysFile sysFile) {
        sysFile.setCompanyId(this.currentCompanyId());
        return success(baseService.page(getPage(), sysFile));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysFile>> getList(SysFile sysFile) {
        sysFile.setCompanyId(this.currentCompanyId());
        return success(baseService.list(sysFile));
    }

    @ApiOperation(value = "查询 id 文件权限", notes = "查询指定 id 的数据文件权限")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/authorize_{id}")
    public PtResult<List<Integer>> getAuthorize(@PathVariable("id") Long id) {
        return success(baseService.getAuthorize(getAccount(), id));
    }

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(MultipartFile file, SysFile sysFile) {
        return success(baseService.save(this.getAccount(), file, sysFile));
    }

    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.removeByIds(this.getAccount(), ids));
    }

    @ApiOperation(value = "历史文件列表", notes = "根据 文件ID 查询历史文件列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fileId", value = "文件ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/list_his/{fileId}")
    public PtResult<List<SysFileHis>> listHis(@PathVariable("fileId") Long fileId) {
        return success(baseService.listHis(fileId));
    }

    @ApiOperation(value = "检出历史文件", notes = "根据 历史ID 检出历史文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fileHisId", value = "历史ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/checkout/{fileHisId}")
    public PtResult<Boolean> checkOutFileHis(@PathVariable("fileHisId") Long fileHisId) {
        return success(baseService.checkOutFileHis(fileHisId));
    }

    @ApiOperation(value = "下载文件", notes = "根据 fileId 下载文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "fileId", value = "主键数组", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "history", value = "是否为历史文件", required = false, paramType = "query", dataType = "boolean"),
    })
    @GetMapping("/download/{fileId}")
    public void download(@PathVariable("fileId") Long fileId, boolean history) {
        baseService.download(response, fileId, history);
    }
}
