package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysFileSignature;
import com.patzn.lims.sys.service.ISysFileSignatureService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * 电子签名文件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
@Api(tags = "电子签名文件表")
@RestController
@RequestMapping("/v1/file_signature")
public class SysFileSignatureController extends ServiceController<ISysFileSignatureService, SysFileSignature> {

    @ApiOperation(value = "下载文件", notes = "根据 userId 下载文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户 ID", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/download/{userId}")
    public void download(@PathVariable("userId") Long userId) {
        baseService.download(userId, response);
    }

    @ApiOperation(value = "下载当前用户电子签名", notes = "下载当前用户 Baser64 格式电子签名")
    @GetMapping("/base64")
    public PtResult<String> download() {
        return success(baseService.downloadBase64(currentUserId()));
    }


    @ApiOperation(value = "用户电子签名", notes = "给指定用户 UserId 添加电子签名")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{userId}")
    public PtResult<Boolean> add(MultipartFile file, @PathVariable("userId") Long userId) {
        return success(baseService.save(file, userId));
    }
}
