package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.sys.entity.SysFileTemplateClassify;
import com.patzn.lims.sys.service.ISysFileTemplateClassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 模板文件分类表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-14
 */
@Api(tags = "模板文件分类表")
@RestController
@RequestMapping("/v1/file_template_classify")
public class SysFileTemplateClassifyController extends ServiceController<ISysFileTemplateClassifyService, SysFileTemplateClassify> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysFileTemplateClassify>> getPage(SysFileTemplateClassify sysFileTemplateClassify) {
        sysFileTemplateClassify.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), sysFileTemplateClassify));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysFileTemplateClassify>> getList(SysFileTemplateClassify sysFileTemplateClassify) {
        sysFileTemplateClassify.setCompanyId(currentCompanyId());
        return success(baseService.list(sysFileTemplateClassify));
    }


    @ApiOperation(value = "获取模板类别树", notes = "获取模板类别树")
    @PutMapping("/get_tree")
    public PtResult<List<Tree>> getTree(SysFileTemplateClassify sysFileTemplateClassify) {
        return success(baseService.getTree(sysFileTemplateClassify));
    }
}
