package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.dto.SysFileTemplateDTO;
import com.patzn.lims.sys.entity.SysFileTemplate;
import com.patzn.lims.sys.service.ISysFileTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * 模板文件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
@Api(tags = "模板文件表")
@RestController
@RequestMapping("/v1/file_template")
public class SysFileTemplateController extends ServiceController<ISysFileTemplateService, SysFileTemplate> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysFileTemplate>> getPage(SysFileTemplateDTO dto) {
        dto.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), dto));
    }

    @ApiOperation(value = "分页 DTO", notes = "分页查询数据列表")
    @PostMapping("/page_dto")
    public PtResult<Page<SysFileTemplate>> getPageDto(@RequestBody SysFileTemplateDTO dto) {
        dto.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), dto));
    }

    @ApiOperation(value = "下载文件", notes = "根据 id 下载文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        baseService.download(id, response);
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<SysFileTemplate> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }

    @ApiOperation(value = "查询 别名 信息", notes = "查询指定 别名 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping({"/alias_{alias}"})
    public PtResult<SysFileTemplate> getByAlias(@PathVariable("alias") String alias, String service) {
        return success(baseService.getByAlias(currentCompanyId(), alias, service));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(MultipartFile file, SysFileTemplate sysFileTemplate) {
        return success(baseService.save(file, sysFileTemplate));
    }

    @ApiOperation(value = "根据 id 删除", notes = "根据 id 删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.removeByIds(ids));
    }
}
