package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysFolder;
import com.patzn.lims.sys.service.ISysFolderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 文件夹表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Api(tags = "文件夹表")
@RestController
@RequestMapping("/v1/folder")
public class SysFolderController extends ServiceController<ISysFolderService, SysFolder> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysFolder>> getPage(SysFolder sysFolder) {
        sysFolder.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), sysFolder));
    }

    @ApiOperation(value = "查询授权列表", notes = "查询授权数据列表")
    @PostMapping("/list")
    public PtResult<List<SysFolder>> getList(SysFolder sysFolder) {
        return success(baseService.listUserAuthorize(getAccount(), sysFolder));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list_all")
    public PtResult<List<SysFolder>> getListAll(SysFolder sysFolder) {
        sysFolder.setCompanyId(currentCompanyId());
        return success(baseService.list(sysFolder));
    }

    @ApiOperation(value = "查询网格显示列表", notes = "查询数据网格显示列表")
    @PostMapping("/list_grid")
    public PtResult<List<Map>> getListGrid(SysFolder sysFolder) {
        List<Map> mapList = null;
        List<SysFolder> sysFolderList = baseService.listUserAuthorize(getAccount(), sysFolder);
        if (CollectionUtils.isNotEmpty(sysFolderList)) {
            mapList = sysFolderList.stream().filter(sf -> !sf.getPid().equals(0L)).map(sf -> {
                Map map = new HashMap(4);
                map.put("id", sf.getId());
                map.put("pid", sf.getPid());
                map.put("name", sf.getName());
                map.put("realname", sf.getRealname());
                map.put("_disabled", true);
                return map;
            }).collect(Collectors.toList());
        }
        return success(mapList);
    }

    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<SysFolder> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }

    @ApiOperation(value = "查询 id 文件夹权限", notes = "查询指定 id 的数据文件夹权限")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/authorize_{id}")
    public PtResult<List<Integer>> getAuthorize(@PathVariable("id") Long id) {
        return success(baseService.getAuthorize(getAccount(), id));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysFolder sysFolder) {
        return success(baseService.updateById(sysFolder));
    }
}
