package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysForm;
import com.patzn.lims.sys.service.ISysFormService;
import com.patzn.lims.sys.vo.SysFormVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 系统表单表 前端控制器
 * </p>
 *
 * @author hubin
 * @since 2019-01-09
 */
@Api(tags = "系统表单表")
@RestController
@RequestMapping("/v1/form")
public class SysFormController extends ServiceController<ISysFormService, SysForm> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
	public PtResult<IPage<SysForm>> getPage(SysForm sysForm) {
        return success(baseService.page(getPage(), sysForm));
	}


    @ApiOperation(value = "分页 VO 列表", notes = "分页查询 VO 数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page-vo")
	public PtResult<Page<SysFormVO>> pageVO(SysFormVO vo) {
        return success(baseService.pageVO(getPage(), vo));
	}


    @ApiOperation(value = "根据 buttonCode 查询表单列表", notes = "查询指定 buttonCode 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "buttonCode", value = "按钮 CODE", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/list-{buttonCode}")
	public PtResult<List<SysForm>> list(@PathVariable("buttonCode") String buttonCode) {
        return success(baseService.listByButtonCode(buttonCode));
	}


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, SysForm sysForm) {
        sysForm.setId(id);
        return success(baseService.updateById(sysForm));
	}
}
