package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.entity.SysFormRelResource;
import com.patzn.lims.sys.service.ISysFormRelResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 系统表单关联资源表 前端控制器
 * </p>
 *
 * @author hubin
 * @since 2019-01-09
 */
@Api(tags = "系统表单关联资源表")
@RestController
@RequestMapping("/v1/form-rel-resource")
public class SysFormRelResourceController extends SuperController {

    @Autowired
    private ISysFormRelResourceService sysFormRelResourceService;

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(SysFormRelResource sysFormRelResource) {
        return success(sysFormRelResourceService.save(sysFormRelResource));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键 ID", required = true, paramType = "path", dataType = "Long"),
            @ApiImplicitParam(name = "remark", value = "备注", paramType = "query", dataType = "String"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysFormRelResource sysFormRelResource) {
        sysFormRelResource.setId(id);
        sysFormRelResource.setCompanyId(currentCompanyId());
        return success(sysFormRelResourceService.updateById(sysFormRelResource));
    }

    @ApiOperation(value = "根据 ID 删除", notes = "根据 ID 删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键 ID", required = true, paramType = "path", dataType = "Long"),
    })
    @DeleteMapping("/{id}")
    public PtResult<Boolean> delete(@PathVariable("id") Long id) {
        return success(sysFormRelResourceService.removeById(id));
    }

}
