package com.patzn.lims.sys.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysIsv;
import com.patzn.lims.sys.service.ISysIsvService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
* <p>
* ISV 信息表 前端控制器
* </p>
*
* @author hubin
* @since 2019-04-04
*/
@Api(tags = "ISV 信息表")
@RestController
@RequestMapping("/v1/isv")
public class SysIsvController extends ServiceController<ISysIsvService, SysIsv> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
        @ApiImplicitParams({
        @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
        @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @GetMapping("/page")
    public PtResult<IPage<SysIsv>> page(SysIsv sysIsv) {
        QueryWrapper qw = new QueryWrapper<>(sysIsv);
        qw.select("id", "app_key", "secret", "status", "remark", "expire_time");
        return success(baseService.page(getPage(), qw));
    }
}
