package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysModule;
import com.patzn.lims.sys.service.ISysModuleService;
import com.patzn.lims.sys.service.ISysUserRelModuleService;
import com.patzn.lims.sys.vo.SysModuleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 模块表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Api(tags = "模块表")
@RestController
@RequestMapping("/v1/module")
public class SysModuleController extends ServiceController<ISysModuleService, SysModule> {
    @Autowired
    private ISysUserRelModuleService sysUserRelModuleService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysModule>> getPage(SysModule sysModule) {
        haveSystemPermissions();
        return success(baseService.page(getPage(), sysModule));
    }


    @ApiOperation(value = "用户模块列表", notes = "分页查询用户添加模块数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page-user")
    public PtResult<IPage<SysModuleVO>> getPageByUserId(SysModule sysModule) {
        return success(baseService.pageByUserId(getPage(), sysModule, getAccount()));
    }


    @ApiOperation(value = "根据系统ID查询企业模块列表", notes = "查询指定系统ID企业数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "companyId", value = "企业 ID", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "systemId", value = "系统 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/list-{companyId}-{systemId}")
    public PtResult<List<SysModule>> getList(@PathVariable("companyId") Long companyId, @PathVariable("systemId") Long systemId) {
        return success(baseService.listCompanyModule(companyId, systemId));
    }


    @ApiOperation(value = "根据系统ID查询用户模块列表", notes = "查询指定系统ID用户模块数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "systemId", value = "系统ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/list-user-{systemId}")
    public PtResult<List<SysModule>> getListUserModule(@PathVariable("systemId") Long systemId) {
        return success(baseService.listSystemModule(systemId, getAccount()));
    }


    @ApiOperation(value = "查询用户模块列表", notes = "查询用户模块数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "type", value = "系统类型", required = true, paramType = "path", dataType = "String"),
    })
    @PostMapping("/list-user-module-{type}")
    public PtResult<List<SysModule>> getListUserModule(@PathVariable("type") String type) {
        return success(baseService.listUserModule(currentUserId(), type));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysModule sysModule) {
        haveSystemPermissions();
        return success(baseService.updateById(sysModule));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(SysModule sysModule) {
        haveSystemPermissions();
        return super.add(sysModule);
    }


    @ApiOperation(value = "添加用户模块", notes = "添加用户模块自动关联")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模块主键", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/rel-user/{id}")
    public PtResult<Boolean> addRelUser(@PathVariable("id") Long id) {
        return success(baseService.saveRelUser(currentUserId(), id));
    }


    @ApiOperation(value = "删除用户模块", notes = "根据用户模块关联主键删除关联关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "relId", value = "用户模块关联主键", required = true, paramType = "path", dataType = "long"),
    })
    @DeleteMapping("/rel-user/{relId}")
    public PtResult<Boolean> deleteRelUser(@PathVariable("relId") Long relId) {
        return success(baseService.deleteRelUser(relId));
    }


    @ApiOperation(value = "删除用户模块", notes = "根据模块ID删除关联关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "moduleId", value = "模块主键", required = true, paramType = "path", dataType = "long"),
    })
    @DeleteMapping("/rel-user-module/{moduleId}")
    public PtResult<Boolean> deleteRelUserModule(@PathVariable("moduleId") Long moduleId) {
        return success(sysUserRelModuleService.remove(currentUserId(), moduleId));
    }

}
