package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.sys.entity.SysOperateLog;
import com.patzn.lims.sys.service.ISysOperateLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
* <p>
* 操作日志表 前端控制器
* </p>
*
* @author hubin
* @since 2019-05-25
*/
@Api(tags = "操作日志表")
@RestController
@RequestMapping("/v1/operate-log")
public class SysOperateLogController extends SuperController {
    @Autowired
    private ISysOperateLogService operateLogService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysOperateLog>> page(SysOperateLog sysOperateLog) {
        return success(operateLogService.page(getPage(), new QueryWrapper<>(sysOperateLog)));
    }

    @DeleteMapping({"/{id}"})
    public PtResult<Boolean> remove(@PathVariable("id") Long id) {
        return this.success(operateLogService.removeById(id));
    }
}
