package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysOrg;
import com.patzn.lims.sys.service.ISysOrgService;
import com.patzn.lims.sys.vo.SysOrgVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 组织表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-08-02
 */
@Api(tags = "组织表")
@RestController
@RequestMapping("/v1/org")
public class SysOrgController extends ServiceController<ISysOrgService, SysOrg> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysOrgVO>> getPage(SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), sysOrg));
    }


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表，JSON 格式请求参数")
    @PostMapping("/page_json")
    public PtResult<Page<SysOrgVO>> getPageJson(@RequestBody SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), sysOrg));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysOrg>> getList(SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.list(sysOrg));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表，JSON 格式请求参数")
    @PostMapping("/list_json")
    public PtResult<List<SysOrg>> getListJson(@RequestBody SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.list(sysOrg));
    }


    @ApiOperation(value = "查询用户部门信息", notes = "查询用户的部门信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "realName", value = "用户真实名称", required = true, paramType = "query", dataType = "string"),
    })
    @GetMapping("/list-user")
    public PtResult<List<SysOrg>> getListByRealName(@RequestParam String realName) {
        return success(baseService.listByUserRealName(realName));
    }


    @ApiOperation(value = "查询组织部门树", notes = "查询组织部门数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "keyword", value = "查询关键词", required = true, paramType = "query", dataType = "string"),
    })
    @PostMapping("/org-tree")
    public PtResult<List<SysOrg>> getOrgTree(String keyword) {
        return success(baseService.getOrgTree(keyword));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<SysOrg> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }


    @ApiOperation(value = "查询当前用户的部门信息", notes = "查询当前用户的第一个部门信息")
    @GetMapping("/current")
    public PtResult<SysOrg> getOrg() {
        return success(baseService.getByUserId(currentUserId()));
    }


    @ApiOperation(value = "查询 id VO 信息", notes = "查询指定 id VO 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo-{id}")
    public PtResult<SysOrgVO> getVo(@PathVariable("id") Long id) {
        return success(baseService.getVoById(currentCompanyId(), id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.updateById(sysOrg));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(SysOrg sysOrg) {
        sysOrg.setCompanyId(currentCompanyId());
        return success(baseService.save(sysOrg));
    }


    @ApiOperation(value = "导入组织", notes = "导入组织数据内容")
    @PostMapping("/import")
    public PtResult<Boolean> importOrg(MultipartFile file) {
        return success(baseService.importOrg(file, getAccount()));
    }

}
