package com.patzn.lims.sys.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysProvince;
import com.patzn.lims.sys.service.ISysProvinceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "省份表")
@RestController
@RequestMapping("/v1/province")
public class SysProvinceController extends ServiceController<ISysProvinceService, SysProvince> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysProvince>> getPage(SysProvince sysProvince) {
        this.haveSystemPermissions();
        return success(baseService.page(getPage(), sysProvince));
    }


    @Login(action = Action.Skip)
    @Cacheable(value = "10minutes", key = "'listByCountryCode2'")
    @ApiOperation(value = "查询中国所有省份列表", notes = "查询所有中国所有省份数据列表")
    @PostMapping("/list-china")
    public PtResult<List<SysProvince>> getListChina() {
        return success(baseService.listByCountryCode2("CN"));
    }



    @ApiOperation(value = "查询所有列表", notes = "查询所有数据列表")
    @PostMapping("/list-all")
    public PtResult<List<Map<String, Object>>> getListAll() {
        return success(baseService.listAll());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysProvince sysProvince) {
        this.haveSystemPermissions();
        return success(baseService.updateById(sysProvince));
    }

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(SysProvince sysProvince) {
        this.haveSystemPermissions();
        return success(baseService.save(sysProvince));
    }
}
