package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.sys.service.ISysResourceService;
import com.patzn.lims.sys.vo.SysResourceVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 资源表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "资源表")
@RestController
@RequestMapping("/v1/resource")
public class SysResourceController extends ServiceController<ISysResourceService, SysResource> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysResourceVO>> getPage(SysResource sysResource) {
        return success(baseService.page(getPage(), sysResource));
    }

    @ApiOperation(value = "按钮分页列表", notes = "按钮分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page-btn")
    public PtResult<Page<SysResourceVO>> getPageBtn(SysResource sysResource) {
        return success(baseService.pageBtn(getPage(), sysResource));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysResource>> getList(SysResource sysResource) {
        return success(baseService.list(Wrappers.query(sysResource)));
    }

    @ApiOperation(value = "查询按钮列表", notes = "查询按钮数据列表")
    @PostMapping("/list-btn")
    public PtResult<List<String>> getListBtn() {
        return success(baseService.listBtn(getAccount()));
    }

    @ApiOperation(value = "查询导航菜单", notes = "查询资源导航菜单")
    @PostMapping("/nav-menu-{code}")
    public PtResult<List<Object>> getNavMenu(@PathVariable("code") String code) {
        return success(baseService.getNavMenu(currentUserId(), code));
    }

    @ApiOperation(value = "查询APP菜单", notes = "查询资源APP菜单")
    @PostMapping("/app-menu")
    public PtResult<List<SysResource>> getAppMenu() {
        return success(baseService.getAppMenu(currentUserId()));
    }


    @ApiOperation(value = "查询菜单树", notes = "查询资源菜单树")
    @PostMapping("/menu-tree")
    public PtResult<List<SysResource>> getMenuTree(SysResourceVO vo) {
        if (null == vo.getSystemId()) {
            vo.setCompanyId(currentCompanyId());
        }
        return success(baseService.getMenuTree(vo));
    }

    @Override
    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<SysResource> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }

    @ApiOperation(value = "查询 id VO 信息", notes = "查询指定 id VO 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo-{id}")
    public PtResult<SysResourceVO> getVo(@PathVariable("id") Long id) {
        return success(baseService.getVoById(id));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysResource sysResource) {
        sysResource.setId(id);
        return success(baseService.updateById(setButtonUri(sysResource)));
    }

    @Override
    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(SysResource sysResource) {
        if (null != sysResource.getCode()) {
            sysResource.setCode(sysResource.getCode().trim());
        }
        sysResource.setCtime(new Date());
        return success(baseService.save(sysResource));
    }

    @ApiOperation(value = "添加按钮", notes = "添加一个按钮")
    @PostMapping("/btn-{menuId}")
    public PtResult<Boolean> addBtn(@PathVariable("menuId") Long menuId, SysResource sysResource) {
        return success(baseService.saveBtn(menuId, setButtonUri(sysResource)));
    }

    /**
     * 设置按钮 uri
     */
    private SysResource setButtonUri(SysResource sysResource) {
        if (null != sysResource.getType() && 1 == sysResource.getType()) {
            if ("reportBtn".equals(sysResource.getUri())
                    || "formBtn".equals(sysResource.getUri())) {
                sysResource.setUri(sysResource.getUri());
            } else {
                sysResource.setUri("/");
            }
        }
        return sysResource;
    }
}
