package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.core.type.TypeReference;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.toolkit.JacksonUtils;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysRole;
import com.patzn.lims.sys.entity.SysRoleRelResource;
import com.patzn.lims.sys.service.ISysRoleRelResourceService;
import com.patzn.lims.sys.service.ISysRoleService;
import com.patzn.lims.sys.vo.SysRoleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 角色前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-08-02
 */
@Api(tags = "角色表")
@RestController
@RequestMapping("/v1/role")
public class SysRoleController extends ServiceController<ISysRoleService, SysRole> {
    @Autowired
    private ISysRoleRelResourceService sysRoleRelResourceService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysRoleVO>> getPage(SysRole sysRole) {
        sysRole.setCompanyId(currentCompanyId());
        return success(baseService.page(getPage(), sysRole));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysRole>> getList(SysRole sysRole) {
        sysRole.setCompanyId(currentCompanyId());
        return success(baseService.list(sysRole));
    }

    @ApiOperation(value = "查询角色树", notes = "查询角色数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "角色名称", paramType = "query", dataType = "String"),
    })
    @PostMapping("/role-tree")
    public PtResult<List<SysRole>> getRoleTree(String name) {
        return success(baseService.getRoleTree(name));
    }

    @ApiOperation(value = "分配权限", notes = "添加角色权限关联关系")
    @PostMapping("/rel-resource/{roleId}")
    public PtResult<Boolean> addRelResource(@PathVariable("roleId") Long roleId, String resourceIds) {
        if (StringUtils.isEmpty(resourceIds)) {
            return success(false);
        }
        List<String> resourceIdList = JacksonUtils.readValue(resourceIds, new TypeReference<List<String>>() {
        });
        List<Long> ids = new ArrayList<>();
        for (String resourceId : resourceIdList) {
            ids.add(Long.valueOf(resourceId));
        }
        return success(sysRoleRelResourceService.addRelResource(roleId, ids));
    }

    @ApiOperation(value = "关联权限", notes = "查询角色已经关联的权限列表")
    @GetMapping("/get-rel-resource/{roleId}")
    public PtResult<List<SysRoleRelResource>> getRelResource(@PathVariable("roleId") Long roleId) {
        return success(sysRoleRelResourceService.getRelResource(roleId));
    }

    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<SysRole> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }

    @ApiOperation(value = "查询 id VO 信息", notes = "查询指定 id VO 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo-{id}")
    public PtResult<SysRoleVO> getVo(@PathVariable("id") Long id) {
        return success(baseService.getVoById(currentCompanyId(), id));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysRole sysRole) {
        sysRole.setCompanyId(currentCompanyId());
        return success(baseService.updateById(sysRole));
    }

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(SysRole sysRole) {
        sysRole.setCompanyId(currentCompanyId());
        return success(baseService.save(sysRole));
    }
}
