package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysSystem;
import com.patzn.lims.sys.service.ISysSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 系统表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-07-20
 */
@Api(tags = "系统表")
@RestController
@RequestMapping("/v1/system")
public class SysSystemController extends ServiceController<ISysSystemService, SysSystem> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysSystem>> getPage(SysSystem sysSystem) {
        return success(baseService.page(getPage(), sysSystem));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysSystem>> getList(SysSystem sysSystem) {
        return success(baseService.list(Wrappers.query(sysSystem)));
    }


    @ApiOperation(value = "查询 id name 字段列表", notes = "查询数据只需要 id name 字段列表")
    @GetMapping("/list-id-name")
    public PtResult<List<SysSystem>> listIdName() {
        return success(baseService.listIdName());
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysSystem sysSystem) {
        return success(baseService.updateById(sysSystem));
    }

    @Override
    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(SysSystem sysSystem) {
        return success(baseService.save(sysSystem));
    }
}
