package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.dto.TableColumnDTO;
import com.patzn.lims.sys.dto.UserTableColumnDTO;
import com.patzn.lims.sys.entity.SysResource;
import com.patzn.lims.sys.entity.SysTableColumn;
import com.patzn.lims.sys.service.ISysCompanyRelTableColumnService;
import com.patzn.lims.sys.service.ISysTableColumnService;
import com.patzn.lims.sys.service.ISysUserRelTableColumnService;
import com.patzn.lims.sys.vo.SysTableColumnVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 系统表格字段表 前端控制器
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
@Api(tags = "系统表格字段表")
@RestController
@RequestMapping("/v1/table-column")
public class SysTableColumnController extends ServiceController<ISysTableColumnService, SysTableColumn> {
    @Autowired
    private ISysCompanyRelTableColumnService sysCompanyRelTableColumnService;
    @Autowired
    private ISysUserRelTableColumnService sysUserRelTableColumnService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<Page<SysTableColumnVO>> getPage(SysTableColumn sysTableColumn) {
        return success(baseService.page(getPage(), sysTableColumn));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysTableColumn>> getList(SysTableColumn sysTableColumn) {
        return success(baseService.list(sysTableColumn));
    }


    @ApiOperation(value = "查询企业表字段列表", notes = "查询企业表字段勾选列表")
    @PostMapping("/list-company-{id}")
    public PtResult<List<Long>> getCompanyList(@PathVariable("id") Long id) {
        return success(sysCompanyRelTableColumnService.listIds(id));
    }


    @ApiOperation(value = "查询当前企业指定表字段列表", notes = "查询当前企业指定表字段勾选列表")
    @PostMapping("/list-company-code-{tableName}")
    public PtResult<List<String>> getCompanyList(@PathVariable("tableName") String tableName) {
        return success(baseService.listCodes(currentCompanyId(), tableName));
    }


    @ApiOperation(value = "查询当前用户指定表字段列表", notes = "查询当前用户指定表字段勾选列表")
    @PostMapping("/list-user-{tableName}")
    public PtResult<List<String>> getUserList(@PathVariable("tableName") String tableName) {
        return success(sysUserRelTableColumnService.listCodes(getAccount(), tableName));
    }


    @ApiOperation(value = "查询表格字段资源树", notes = "查询表格字段管理资源树数据")
    @PostMapping("/list-tree-{companyId}")
    public PtResult<List<SysResource>> getListTree(@PathVariable("companyId") Long companyId) {
        return success(sysCompanyRelTableColumnService.listTree(companyId));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysTableColumn sysTableColumn) {
        sysTableColumn.setId(id);
        return success(baseService.updateById(sysTableColumn));
    }


    @ApiOperation(value = "添加企业勾选字段列表", notes = "添加企业勾选字段列表数据")
    @PostMapping("/company")
    public PtResult<Boolean> addCompany(@RequestBody TableColumnDTO dto) {
        return success(sysCompanyRelTableColumnService.save(dto));
    }


    @ApiOperation(value = "添加用户勾选字段列表", notes = "添加用户勾选字段列表数据")
    @PostMapping("/user")
    public PtResult<Boolean> addUser(@RequestBody UserTableColumnDTO dto) {
        return success(sysUserRelTableColumnService.save(currentUserId(), dto));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.remove(Wrappers.<SysTableColumn>query().in("id", ids)));
    }
}
