package com.patzn.lims.sys.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.entity.SysUserPlatform;
import com.patzn.lims.sys.service.ISysUserPlatformService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 第三方平台用户表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-17
 */
@Api(tags = "第三方平台用户表")
@RestController
@RequestMapping("/v1/user-platform")
public class SysUserPlatformController extends ServiceController<ISysUserPlatformService, SysUserPlatform> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<SysUserPlatform>> getPage(SysUserPlatform sysUserPlatform) {
        return success(baseService.page(getPage(), sysUserPlatform));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<SysUserPlatform>> getList(SysUserPlatform sysUserPlatform) {
        return success(baseService.list(sysUserPlatform));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, SysUserPlatform sysUserPlatform) {
        return success(baseService.updateById(sysUserPlatform));
    }


    /**
     * <p>
     * 绑定第三方平台
     * </p>
     */
    @ResponseBody
    @PostMapping("/bind")
    public PtResult<Boolean> bindPlatform(String code) {
        return success(baseService.bindWechat(currentUserId(), code));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.remove(Wrappers.<SysUserPlatform>query().in("id", ids)));
    }
}
