package com.patzn.lims.sys.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.sys.dto.SysUserRelResourceDTO;
import com.patzn.lims.sys.entity.SysUserRelResource;
import com.patzn.lims.sys.service.ISysUserRelResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 用户关联资源表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-22
 */
@Api(tags = "用户关联资源表")
@RestController
@RequestMapping("/v1/user-rel-resource")
public class SysUserRelResourceController extends ServiceController<ISysUserRelResourceService, SysUserRelResource> {


    @ApiOperation(value = "查询我的权限列表", notes = "查询我的权限数据列表")
    @PostMapping("/my-list")
    public PtResult<List<SysUserRelResource>> getMyList() {
        return success(baseService.list(currentUserId()));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(@RequestBody SysUserRelResourceDTO dto) {
        return success(baseService.save(currentUserId(), dto));
    }
}
