package com.patzn.lims.sys.controller;

import com.patzn.lims.sys.dto.WsMsgDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.web.bind.annotation.RestController;

import java.security.Principal;

/**
 * <p>
 * WebSocket 控制器
 * </p>
 *
 * @author hubin
 * @since 2018-11-13
 */
@RestController
@Slf4j
public class WsController {

    /**
     * <p>
     * 通知类消息
     * </p>
     */
    @MessageMapping("/notice")
    @SendTo(WsMsgDTO.TOPIC_NOTICE)
    public WsMsgDTO notice(String content, Principal principal) {
        return new WsMsgDTO("广播推送：" + content, principal.getName());
    }

    /**
     * <p>
     * 通知类消息
     * </p>
     */
    @MessageMapping("/message")
    @SendToUser(value = WsMsgDTO.TOPIC_MESSAGE, broadcast = false)
    public WsMsgDTO message(String content, Principal principal) {
        return new WsMsgDTO("精准推送，只推送到" + principal.getName() + " ：" + content, principal.getName());
    }

    /**
     * <p>
     * 环境报告编制发送消息
     * </p>
     */
    @MessageMapping("/report_make")
    @SendToUser(value = WsMsgDTO.TOPIC_REPORT_MAKE, broadcast = false)
    public WsMsgDTO reportMakeMessage(String content, Principal principal) {
        log.info("=========== 发送消息给报告编制人 ===========");
        return new WsMsgDTO("精准推送，只推送到" + principal.getName() + " ：" + content, principal.getName());
    }

}
