package com.patzn.lims.sys.dto;
import com.patzn.lims.sys.entity.SysMessage;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * MQ 消息内容
 * </p>
 *
 * @author hubin
 * @since 2018-01-05
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper=false)
public class MqMsgDTO extends SysMessage {

    /**
     * 消息发送者 ID 集合
     */
    private List<Long> receiverIds;
    /**
     * 消息发送者
     */
    private String sender;

    /**
     * 业务类型<br>
     * 0、默认初始化值取决于当前的消息主题
     * 1、处理根据工作流别名获取用户信息的消息业务逻辑
     */
    private int businessType;

    /**
     * 业务参数
     */
    private String business;

    /**
     * 服务名称
     */
    private String service;


    public String getSender() {
        // 去掉前后空格
        return null == sender ? null : sender.trim();
    }
}
