package com.patzn.lims.sys.dto;

import com.patzn.lims.sys.entity.SysUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * <p>
 * 用户信息 DTO
 * </p>
 *
 * @author hubin
 * @date 2017-12-07
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysUserDTO extends SysUser {

    @ApiModelProperty(value = "机构 ID 集合 ， 逗号分割")
    private String orgIds;

    @ApiModelProperty(value = "角色 ID 集合 ， 逗号分割")
    private String roleIds;


    public List<Long> orgIdList() {
        if (StringUtils.isEmpty(this.orgIds)) {
            return null;
        }
        String[] orgIdArr = this.orgIds.split(",");
        List<Long> orgIdList = new ArrayList<>();
        for (String orgId : orgIdArr) {
            orgIdList.add(Long.valueOf(orgId));
        }
        return orgIdList;
    }

    public List<Long> roleIdList() {
        if (StringUtils.isEmpty(this.roleIds)) {
            return null;
        }
        String[] roleIdArr = this.roleIds.split(",");
        List<Long> roleIdList = new ArrayList<>();
        for (String roleId : roleIdArr) {
            roleIdList.add(Long.valueOf(roleId));
        }
        return roleIdList;
    }
}
