package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 地区表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysArea extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "中文名")
  @TableField(condition = SqlCondition.LIKE)
  private String cn;

  @ApiModelProperty(value = "英文名")
  @TableField(condition = SqlCondition.LIKE)
  private String en;

  @ApiModelProperty(value = "地区编码")
  @TableField(condition = SqlCondition.LIKE)
  private String code;

  @ApiModelProperty(value = "城市编码")
  @TableField(condition = SqlCondition.LIKE)
  private String cityCode;


}
