package com.patzn.lims.sys.entity;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * ip黑名单
 * </p>
 *
 * @author patzn
 * @since 2018-07-04
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysBlackList extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "ip")
  private String ip;

  @ApiModelProperty(value = "用户id")
  private Long userId;

  @ApiModelProperty(value = "最近封号时间")
  private Date recentStopTime;

  @ApiModelProperty(value = "最近解封时间")
  private Date recentOpenTime;

  @ApiModelProperty(value = "被封总次数")
  private Integer totalCount;

  @ApiModelProperty(value = "状态（0封号，1解封）")
  private Integer status;

  @ApiModelProperty(value = "解封人id")
  private Long releaseId;

  @ApiModelProperty(value = "解封人姓名")
  private String releaseName;

}
