package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 公司表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysCompany extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "名称")
  @TableField(condition = SqlCondition.LIKE)
  private String name;

  @ApiModelProperty(value = "类型（1、企业 2、第三方检测 3、其他）")
  private Integer type;

  @ApiModelProperty(value = "管理员")
  @TableField(condition = SqlCondition.LIKE)
  private String manager;

  @ApiModelProperty(value = "二级域名")
  @TableField(condition = SqlCondition.LIKE)
  private String domain;

  @ApiModelProperty(value = "LOGO")
  private String logo;

  @ApiModelProperty(value = "国家二字码")
  @TableField(condition = SqlCondition.LIKE)
  private String countryCode2;

  @ApiModelProperty(value = "省份编码")
  private String provinceCode;

  @ApiModelProperty(value = "城市编码")
  private String cityCode;

  @ApiModelProperty(value = "地区编码")
  private String areaCode;

  @ApiModelProperty(value = "联系人")
  @TableField(condition = SqlCondition.LIKE)
  private String contact;

  @ApiModelProperty(value = "联系方式")
  @TableField(condition = SqlCondition.LIKE)
  private String contactWay;

  @ApiModelProperty(value = "联系地址")
  @TableField(condition = SqlCondition.LIKE)
  private String contactAddress;

  @ApiModelProperty(value = "营业执照编号")
  @TableField(condition = SqlCondition.LIKE)
  private String busno;

  @ApiModelProperty(value = "营业执照图片")
  private String busimg;

  @ApiModelProperty(value = "网址")
  @TableField(condition = SqlCondition.LIKE)
  private String website;

  @ApiModelProperty(value = "单位代码")
  @TableField(condition = SqlCondition.LIKE)
  private String code;

  @ApiModelProperty(value = "电话")
  @TableField(condition = SqlCondition.LIKE)
  private String phone;

  @ApiModelProperty(value = "传真")
  @TableField(condition = SqlCondition.LIKE)
  private String fax;

  @ApiModelProperty(value = "邮编")
  @TableField(condition = SqlCondition.LIKE)
  private String zipcode;

  @ApiModelProperty(value = "备注")
  @TableField(condition = SqlCondition.LIKE)
  private String remark;

  @ApiModelProperty(value = "通知微信 0、否 1、是")
  private Integer notifyWechat;

  @ApiModelProperty(value = "状态（0、禁用 1、正常）")
  private Integer status;

  @ApiModelProperty(value = "排序")
  private Integer sort;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


  @ApiModelProperty(value = "联盟企业")
  private String unionCompany;


  @ApiModelProperty(value = "联盟企业ID")
  private Long unionCompanyId;
}
