package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 国家表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysCountry extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "中文名")
  @TableField(condition = SqlCondition.LIKE)
  private String cn;

  @ApiModelProperty(value = "英文名")
  @TableField(condition = SqlCondition.LIKE)
  private String en;

  @ApiModelProperty(value = "二字码")
  @TableField(condition = SqlCondition.LIKE)
  private String code2;

  @ApiModelProperty(value = "三字码")
  @TableField(condition = SqlCondition.LIKE)
  private String code3;


}
