package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 文件表
 * </p>
 *
 * @author patzn
 * @since 2017-11-01
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel
public class SysFile extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "文件夹 ID")
	private Long folderId;

    @ApiModelProperty(value = "编号")
	private String num;

    @ApiModelProperty(value = "名称")
	@TableField(condition = SqlCondition.LIKE)
	private String name;

    @ApiModelProperty(value = "桶名称")
	private String bucketName;

    @ApiModelProperty(value = "对象key")
	private String objectKey;

    @ApiModelProperty(value = "版本号")
	private String versionId;

    @ApiModelProperty(value = "类型")
	private String type;

    @ApiModelProperty(value = "0、共享 1、私有")
	private Integer share;

    @ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "真实名称")
	@TableField(condition = SqlCondition.LIKE, fill = FieldFill.INSERT)
	private String realname;

    @ApiModelProperty(value = "用户 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "    状态 0正常 1签入中 2 销毁中 3已销毁")
	private Integer status;


}
