package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 文件历史表
 * </p>
 *
 * @author patzn
 * @since 2017-11-01
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel
public class SysFileHis extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "文件 ID")
    private Long fileId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "桶名称")
    private String bucketName;

    @ApiModelProperty(value = "对象key")
    private String objectKey;

    @ApiModelProperty(value = "版本")
    private String versionId;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "0、共享 1、私有")
    private Integer share;

    @ApiModelProperty(value = "真实名称")
    @TableField(condition = SqlCondition.LIKE, fill = FieldFill.INSERT)
    private String realname;

    @ApiModelProperty(value = "用户 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;


}
