package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 模板文件表
 * </p>
 *
 * @author patzn
 * @since 2018-04-02
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysFileTemplate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "分类 ID")
    private Long classifyId;

    @ApiModelProperty(value = "企业 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;

    @ApiModelProperty(value = "名称")
    @TableField(condition = SqlCondition.LIKE)
    private String name;

    @ApiModelProperty(value = "别名")
    @TableField(condition = SqlCondition.LIKE)
    private String alias;

    @ApiModelProperty(value = "服务名")
    private String service;

    @ApiModelProperty(value = "桶名称")
    private String bucketName;

    @ApiModelProperty(value = "对象key")
    private String objectKey;

    @ApiModelProperty(value = "版本")
    private String versionId;

    @ApiModelProperty(value = "类型")
    @TableField(condition = SqlCondition.LIKE)
    private String type;

    @ApiModelProperty(value = "用户 ID")
    @TableField(fill = FieldFill.INSERT)
    private Long uid;

    @ApiModelProperty(value = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date ctime;


}
