package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 文件夹表
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel
public class SysFolder extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "父 ID")
	private Long pid;

    @ApiModelProperty(value = "名称")
	private String name;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "真实名称")
	@TableField(condition = SqlCondition.LIKE, fill = FieldFill.INSERT)
	private String realname;

	@ApiModelProperty(value = "用户 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
