package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 系统表单表
 * </p>
 *
 * @author hubin
 * @since 2019-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysForm extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "企业 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "名称")
  @TableField(condition = SqlCondition.LIKE)
  private String name;

  @ApiModelProperty(value = "自定义地址")
  @TableField(condition = SqlCondition.LIKE)
  private String uri;

  @ApiModelProperty(value = "备注")
  @TableField(condition = SqlCondition.LIKE)
  private String remark;

  @ApiModelProperty(value = "操作人 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long uid;

  @ApiModelProperty(value = "操作人")
  @TableField(fill = FieldFill.INSERT)
  private String operator;

  @ApiModelProperty(value = "修改人 ID")
  @TableField(fill = FieldFill.UPDATE)
  private Long lid;

  @ApiModelProperty(value = "修改时间")
  @TableField(fill = FieldFill.UPDATE)
  private Date ltime;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
