package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 系统表单关联资源表
 * </p>
 *
 * @author hubin
 * @since 2019-01-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysFormRelResource extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "企业 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "表单 ID")
  private Long formId;

  @ApiModelProperty(value = "资源 ID")
  private Long resourceId;

  @ApiModelProperty(value = "备注")
  @TableField(condition = SqlCondition.LIKE)
  private String remark;


}
