package com.patzn.lims.sys.entity;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * ISV 信息表
 * </p>
 *
 * @author hubin
 * @since 2019-04-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "SysIsv对象", description = "ISV 信息表")
public class SysIsv extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "appKey")
  private String appKey;

  @ApiModelProperty(value = "secret")
  private String secret;

  @ApiModelProperty(value = "公钥")
  private String publicKey;

  @ApiModelProperty(value = "私钥")
  private String privateKey;

  @ApiModelProperty(value = "0、禁用 1、启用")
  private Integer status;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "过期时间，无永久")
  private Date expireTime;


}
