package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 系统消息表
 * </p>
 *
 * @author patzn
 * @since 2018-01-03
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysMessage extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "企业 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "创建人 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long uid;

  @ApiModelProperty(value = "类型 0、通知 1、消息  2、待办")
  private Integer type;

  @ApiModelProperty(value = "请求URI")
  private String uri;

  @ApiModelProperty(value = "IP 地址")
  private String ip;

  @ApiModelProperty(value = "标题")
  @TableField(condition = SqlCondition.LIKE)
  private String title;

  @ApiModelProperty(value = "内容")
  private String content;

  @ApiModelProperty(value = "已发送 0、否 1、是")
  private Integer send;

  @ApiModelProperty(value = "开始时间")
  private Date beginTime;

  @ApiModelProperty(value = "结束时间")
  private Date endTime;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;

  @ApiModelProperty(value = "消息类型")
  private String msgType;


  public String getContent() {
    // 去掉前后空格
    return null == content ? null : content.trim();
  }

  public String getTitle() {
    // 去掉前后空格
    return null == title ? null : title.trim();
  }
}
