package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 消息类型配置表
 * </p>
 *
 * @author ldx
 * @since 2018-11-13
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysMessageType extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "消息类型")
  private String msgType;

  @ApiModelProperty(value = "跳转链接")
  private String link;

  @ApiModelProperty(value = "企业id")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "创建人id")
  @TableField(fill = FieldFill.INSERT)
  private Long uid;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;

  @ApiModelProperty(value = "最后修改人ID")
  @TableField(fill = FieldFill.UPDATE)
  private Long lid;

  @ApiModelProperty(value = "最后修改时间")
  @TableField(fill = FieldFill.UPDATE)
  private Date ltime;

  @ApiModelProperty(value = "是否删除0否，1是")
  @TableLogic
  private Integer deleted;


}
