package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.sys.enums.SysModuleTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 模块表
 * </p>
 *
 * @author patzn
 * @since 2017-10-25
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysModule extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "系统 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long systemId;

  @ApiModelProperty(value = "模块名称")
  @TableField(condition = SqlCondition.LIKE)
  private String name;

  @ApiModelProperty(value = "别名")
  private String alias;

  @ApiModelProperty(value = "类型")
  private SysModuleTypeEnum type;

  @ApiModelProperty(value = "状态")
  private Integer status;

  @ApiModelProperty(value = "图片")
  private String img;

  @ApiModelProperty(value = "备注")
  private String remark;

}
