package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 操作日志表
 * </p>
 *
 * @author hubin
 * @since 2019-05-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "SysOperateLog对象", description = "操作日志表")
public class SysOperateLog extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主题")
  private String subject;

  @ApiModelProperty(value = "请求 Method")
  private String method;

  @ApiModelProperty(value = "请求 URI")
  private String uri;

  @ApiModelProperty(value = "请求 Referer")
  private String referer;

  @ApiModelProperty(value = "请求参数")
  private String param;

  @ApiModelProperty(value = "返回消息体")
  private String resp;

  @ApiModelProperty(value = "差异内容")
  private String diff;

  @ApiModelProperty(value = "执行类方法")
  private String type;

  @ApiModelProperty(value = "异常信息")
  private String exception;

  @ApiModelProperty(value = "访问 IP")
  private String ip;

  @ApiModelProperty(value = "IP 区域")
  private String region;

  @ApiModelProperty(value = "耗时")
  private Long spend;

  @ApiModelProperty(value = "操作人 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long uid;

  @ApiModelProperty(value = "操作人")
  private String operater;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
