package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 资源表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysResource extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "系统 ID")
  private Long systemId;

  @ApiModelProperty(value = "父 ID")
  private Long pid;

  @ApiModelProperty(value = "名称")
  private String name;

  @ApiModelProperty(value = "英文名称")
  private String ename;

  @ApiModelProperty(value = "类型（0、PC 菜单  1、按钮 2、APP 菜单）")
  private Integer type;

  @ApiModelProperty(value = "权限编码")
  private String code;

  @ApiModelProperty(value = "路径 reportBtn 报表按钮， formBtn 表单按钮")
  private String uri;

  @ApiModelProperty(value = "图标")
  private String icon;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "状态（0、禁用 1、正常）")
  private Integer status;

  @ApiModelProperty(value = "排序")
  private Integer sort;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
