package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.sys.enums.FolderAuthorizeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 角色文件夹关联表
 * </p>
 *
 * @author patzn
 * @since 2017-11-06
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel
public class SysRoleRelFileFolder extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "公司 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "文件夹 ID")
	private Long folderId;

    @ApiModelProperty(value = "角色 ID")
	private Long roleId;

    @ApiModelProperty(value = "授权 0、查看 1、上传 2、删除")
	private FolderAuthorizeEnum authorize;


}
