package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 系统表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysSystem extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "名称")
  @TableField(condition = SqlCondition.LIKE)
  private String name;

  @ApiModelProperty(value = "标题")
  private String title;

  @ApiModelProperty(value = "图标")
  private String icon;

  @ApiModelProperty(value = "背景")
  private String banner;

  @ApiModelProperty(value = "主题")
  private String theme;

  @ApiModelProperty(value = "主页")
  private String home;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "状态（0、禁用 1、正常）")
  private Integer status;

  @ApiModelProperty(value = "排序")
  private Integer sort;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
