package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 系统表格字段表
 * </p>
 *
 * @author hubin
 * @since 2018-10-31
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysTableColumn extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "菜单 ID")
  private Long menuId;

  @ApiModelProperty(value = "名称")
  @TableField(condition = SqlCondition.LIKE)
  private String name;

  @ApiModelProperty(value = "标题")
  @TableField(condition = SqlCondition.LIKE)
  private String title;

  @ApiModelProperty(value = "编码")
  @TableField(condition = SqlCondition.LIKE)
  private String code;


}
