package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.sys.enums.SysUserAccreditEnum;
import com.patzn.lims.sys.enums.SysUserTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 用户表
 * </p>
 *
 * @author patzn
 * @since 2017-09-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysUser extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "公司 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "帐号")
  @TableField(condition = SqlCondition.LIKE)
  private String username;

  @ApiModelProperty(value = "密码MD5(密码+盐)")
  private String password;

  @ApiModelProperty(value = "二次认证密钥")
  private String totp;

  @ApiModelProperty(value = "类型")
  private SysUserTypeEnum type;

  @ApiModelProperty(value = "真实名称")
  @TableField(condition = SqlCondition.LIKE)
  private String realname;

  @ApiModelProperty(value = "性别")
  private Integer sex;

  @ApiModelProperty(value = "头像")
  private String avatar;

  @ApiModelProperty(value = "手机")
  @TableField(condition = SqlCondition.LIKE)
  private String mobile;

  @ApiModelProperty(value = "邮箱")
  @TableField(condition = SqlCondition.LIKE)
  private String email;

  @ApiModelProperty(value = "QQ")
  @TableField(condition = SqlCondition.LIKE)
  private String qq;

  @ApiModelProperty(value = "状态")
  private Integer status;

  @ApiModelProperty(value = "注册 IP")
  private String regip;

  @ApiModelProperty(value = "注册时间")
  private Date regtime;

  @ApiModelProperty(value = "开通二次认证")
  private Integer twofactor;

  @ApiModelProperty(value = "邮箱已验证")
  private Integer verifyEmail;

  @ApiModelProperty(value = "手机已验证")
  private Integer verifyMobile;

  @ApiModelProperty(value = "系统管理员 0、否 1、是")
  private Integer admin;

  @ApiModelProperty(value = "授权")
  private SysUserAccreditEnum accredit;

  @ApiModelProperty(value = "通知微信 0、否 1、是")
  private Integer notifyWechat;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;

  @ApiModelProperty(value = "启用账户 0、否 1、是")
  private Integer accountEnabled;

  @ApiModelProperty(value = "启用账户 0、否 1、是")
  private Integer accountLocked;

  @ApiModelProperty(value = "账户过期时间")
  @TableField(fill = FieldFill.INSERT)
  private Date accountExpired;

  @ApiModelProperty(value = "密码过期时间")
  @TableField(fill = FieldFill.INSERT)
  private Date passwordExpired;

}
