package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 第三方平台用户表
 * </p>
 *
 * @author patzn
 * @since 2017-11-17
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysUserPlatform extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "用户 ID")
  private Long userId;

  @ApiModelProperty(value = "平台")
  private Integer platform;

  @ApiModelProperty(value = "放开平台 ID")
  private String openid;

  @ApiModelProperty(value = "平台唯一 ID")
  private String unionid;

  @ApiModelProperty(value = "昵称")
  private String nickname;

  @ApiModelProperty(value = "性别 0、女 1、男")
  private Integer sex;

  @ApiModelProperty(value = "语言")
  private String language;

  @ApiModelProperty(value = "国家")
  private String country;

  @ApiModelProperty(value = "省")
  private String province;

  @ApiModelProperty(value = "城市")
  private String city;

  @ApiModelProperty(value = "头像地址")
  private String headimgurl;

  @ApiModelProperty(value = "首次登录时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
