package com.patzn.lims.sys.entity;

import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.sys.enums.BoolEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户文件夹关联表
 * </p>
 *
 * @author patzn
 * @since 2017-10-30
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel
public class SysUserRelFile extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "文件 ID")
	private Long fileId;

    @ApiModelProperty(value = "用户 ID")
	private Long userId;

    @ApiModelProperty(value = "可读 0、否 1、是")
	private BoolEnum read;

    @ApiModelProperty(value = "可写 0、否 1、是")
	private BoolEnum write;

    @ApiModelProperty(value = "可删 0、否 1、是")
	private BoolEnum remove;


}
