package com.patzn.lims.sys.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 用户消息关联表
 * </p>
 *
 * @author patzn
 * @since 2017-12-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysUserRelMessage extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "企业 ID")
  @TableField(fill = FieldFill.INSERT)
  private Long companyId;

  @ApiModelProperty(value = "用户 ID")
  private Long userId;

  @ApiModelProperty(value = "消息 ID")
  private Long messageId;

  @ApiModelProperty(value = "类型 0、通知 1、消息  2、待办")
  private Integer type;

  @ApiModelProperty(value = "已读 0、否 1、是")
  private Integer read;

  @ApiModelProperty(value = "创建时间")
  @TableField(fill = FieldFill.INSERT)
  private Date ctime;


}
