package com.patzn.lims.sys.entity;

import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.sys.enums.WxTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 微信公众号用户表
 * </p>
 *
 * @author patzn
 * @since 2018-03-12
 */
@Data
@Accessors(chain = true)
@ApiModel
public class SysWxmpUser extends BaseEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "用户 ID")
  private Long userId;

  @ApiModelProperty(value = "放开平台 ID")
  private String openid;

  @ApiModelProperty(value = "平台唯一 ID")
  private String unionid;

  @ApiModelProperty(value = "类型 0、公众号 1、小程序")
  private WxTypeEnum type;

  @ApiModelProperty(value = "昵称")
  private String nickname;

  @ApiModelProperty(value = "性别 0、女 1、男")
  private Integer sex;

  @ApiModelProperty(value = "语言")
  private String language;

  @ApiModelProperty(value = "国家")
  private String country;

  @ApiModelProperty(value = "省")
  private String province;

  @ApiModelProperty(value = "城市")
  private String city;

  @ApiModelProperty(value = "头像地址")
  private String headimgurl;

  @ApiModelProperty(value = "订阅 0、无 1、是")
  private Integer subscribe;

  @ApiModelProperty(value = "订阅时间")
  private Date subscribeTime;

}
