package com.patzn.lims.sys.entity;

import com.patzn.lims.core.bean.BeanConvert;
import com.patzn.lims.core.toolkit.JacksonUtils;

/**
 * <p>
 * 微信访问 User
 * </p>
 *
 * @author jobob
 * @since 2017-11-16
 */
public class WxUser extends BeanConvert {

  private String openid;
  private String nickname;
  private Integer sex;
  private String language;
  private String province;
  private String city;
  private String country;
  private String headimgurl;
  private String[] privilege;
  private String unionid;


  public static WxUser convert(String content) {
    return JacksonUtils.readValue(content, WxUser.class);
  }

  public String getOpenid() {
    return openid;
  }

  public void setOpenid(String openid) {
    this.openid = openid;
  }

  public String getNickname() {
    return nickname;
  }

  public void setNickname(String nickname) {
    this.nickname = nickname;
  }

  public Integer getSex() {
    return sex;
  }

  public void setSex(Integer sex) {
    this.sex = sex;
  }

  public String getLanguage() {
    return language;
  }

  public void setLanguage(String language) {
    this.language = language;
  }

  public String getProvince() {
    return province;
  }

  public void setProvince(String province) {
    this.province = province;
  }

  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getHeadimgurl() {
    return headimgurl;
  }

  public void setHeadimgurl(String headimgurl) {
    this.headimgurl = headimgurl;
  }

  public String[] getPrivilege() {
    return privilege;
  }

  public void setPrivilege(String[] privilege) {
    this.privilege = privilege;
  }

  public String getUnionid() {
    return unionid;
  }

  public void setUnionid(String unionid) {
    this.unionid = unionid;
  }
}
