package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 布尔枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum BoolEnum implements IBaseEnum {
    /**
     * 0、否
     */
    FALSE(0, "否"),
    /**
     * 1、是
     */
    TRUE(1, "是");

    private int value;
    private String display;

    BoolEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    /**
     * <p>
     * 显示数值对应的汉字
     * </p>
     *
     * @param value 0 1 数值
     * @return
     */
    public static String display(int value) {
        return 1 == value ? TRUE.display : FALSE.display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}
