package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 文件授权枚举
 * </p>
 *
 * @author hubin
 * @since 2017-10-17
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum FolderAuthorizeEnum implements IBaseEnum {
    /**
     * 可查看文件夹内容
     */
    LOOK(0, "查看"),
    /**
     * 可上传内容至文件夹
     */
    UPLOAD(1, "上传"),
    /**
     * 可删除文件夹内容
     */
    REMOVE(2, "删除");




    private int value;
    private String display;

    FolderAuthorizeEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}
