package com.patzn.lims.sys.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 消息类型枚举
 * </p>
 *
 * @author hubin
 * @since 2017-11-13
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SysMessageTypeEnum implements IBaseEnum {
  /**
   * 0、系统消息
   */
  SYSTEM(0, "系统消息"),
  /**
   * 1、工作流消息
   */
  WORKFLOW(1, "工作流消息");

  private int value;
  private String display;

  SysMessageTypeEnum(final int value, final String display) {
    this.value = value;
    this.display = display;
  }

  @Override
  public Serializable getValue() {
    return this.value;
  }

  @Override
  public String getName() {
    return this.name();
  }

  @Override
  public String getDisplay() {
    return this.display;
  }
}
